/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.gver.dsl.procedure;

import java.io.IOException;
import org.dmfs.gver.dsl.Log;
import org.dmfs.jems2.FragileProcedure;
import org.dmfs.jems2.iterable.Mapped;
import org.dmfs.jems2.optional.First;
import org.dmfs.semver.Version;
import org.dmfs.semver.VersionSequence;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;

public final class CreateTag
implements FragileProcedure<Repository, IOException> {
    private final Log mLog;
    private final Version mVersion;

    public CreateTag(Log logger, Version version) {
        this.mLog = logger;
        this.mVersion = version;
    }

    public void process(Repository repository) throws IOException {
        try {
            Git git = new Git(repository);
            if (git.status().call().hasUncommittedChanges()) {
                throw new IOException("Not creating tag on dirty working tree. Please commit, stash or revert any uncommitted changes first.");
            }
            ObjectId headId = repository.resolve("HEAD");
            RevCommit head = repository.parseCommit((AnyObjectId)headId);
            String versionString = new VersionSequence(this.mVersion).toString();
            if (!new First(versionString::equals, (Iterable)new Mapped(tag -> tag.getName().startsWith("refs/tags/") ? tag.getName().substring("refs/tags/".length()) : tag.getName(), (Iterable)git.tagList().call())).isPresent()) {
                git.tag().setObjectId((RevObject)head).setName(versionString).call();
            } else {
                this.mLog.log("Tag {} already exists. Not adding tag.", versionString);
            }
        }
        catch (GitAPIException apiException) {
            throw new IOException("Error while executing Git Command", apiException);
        }
    }
}

