/*
 * Copyright (C) 2016 Marten Gajda <marten@dmfs.org>
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.dmfs.httpessentials.typedentity;

/**
 * Interface of an entity that has a specific {@link EntityType} and a value.
 * 
 * @author Marten Gajda <marten@dmfs.org>
 * 
 * @param <ValueType>
 *            The type of the entity value.
 */
public interface Entity<ValueType>
{
	/**
	 * Returns the {@link EntityType} of this value.
	 * 
	 * @return A {@link EntityType}.
	 */
	public EntityType<ValueType> type();


	/**
	 * Returns the actual value of this entity.
	 * 
	 * @return The value.
	 */
	public ValueType value();


	/**
	 * Returns the String representation of the entity value.
	 * 
	 * @return The properly encoded value string.
	 */
	public String toString();
}
