/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.headers;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.dmfs.httpessentials.headers.EmptyHeaders;
import org.dmfs.httpessentials.headers.Header;
import org.dmfs.httpessentials.headers.HeaderType;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.headers.ListHeaderType;
import org.dmfs.httpessentials.headers.SingletonHeaderType;
import org.dmfs.httpessentials.headers.UpdatedHeaders;
import org.dmfs.iterators.SingletonIterator;

public final class SingletonHeaders
implements Headers {
    private final Header<?> mHeader;

    public SingletonHeaders(Header<?> header) {
        this.mHeader = header;
    }

    public Iterator<Header<?>> iterator() {
        return new SingletonIterator(this.mHeader);
    }

    public boolean contains(HeaderType<?> headerType) {
        return this.mHeader.type().equals(headerType);
    }

    public <T> Header<T> header(SingletonHeaderType<T> headerType) {
        if (!this.mHeader.type().equals(headerType)) {
            throw new NoSuchElementException(String.format("Single header in SingletonHeaders is not a %s.", headerType.name()));
        }
        return this.mHeader;
    }

    public <T> Header<List<T>> header(ListHeaderType<T> headerType) {
        if (!this.mHeader.type().equals(headerType)) {
            throw new NoSuchElementException(String.format("Single header in SingletonHeaders is not a %s.", headerType.name()));
        }
        return this.mHeader;
    }

    public <T> Headers withHeader(Header<T> header) {
        if (this.mHeader.type().equals(header.type())) {
            return new SingletonHeaders(header);
        }
        return new UpdatedHeaders(this, header);
    }

    public <T> Headers withoutHeaderType(HeaderType<T> headerType) {
        if (this.mHeader.type().equals(headerType)) {
            return EmptyHeaders.INSTANCE;
        }
        return this;
    }
}

