/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.mockutils.entities;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.dmfs.httpessentials.client.HttpResponseEntity;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.jems.optional.Optional;
import org.dmfs.jems.optional.elementary.Absent;
import org.dmfs.jems.optional.elementary.Present;

public final class StaticMockResponseEntity
implements HttpResponseEntity {
    private final Optional<MediaType> mContentType;
    private final Optional<Long> mContentLength;
    private final byte[] mContent;

    public StaticMockResponseEntity() {
        this((Optional<MediaType>)new Absent(), (Optional<Long>)new Absent(), new byte[0]);
    }

    public StaticMockResponseEntity(MediaType contentType, String content) throws UnsupportedEncodingException {
        this(contentType, content.getBytes(contentType.charset("UTF-8")));
    }

    public StaticMockResponseEntity(MediaType contentType, long contentLength, String content) throws UnsupportedEncodingException {
        this(contentType, contentLength, content.getBytes(contentType.charset("UTF-8")));
    }

    public StaticMockResponseEntity(MediaType contentType, byte[] content) {
        this(contentType, (long)content.length, content);
    }

    public StaticMockResponseEntity(MediaType contentType, long contentLength, byte[] content) {
        this((Optional<MediaType>)new Present((Object)contentType), (Optional<Long>)new Present((Object)contentLength), content);
    }

    public StaticMockResponseEntity(Optional<MediaType> contentType, Optional<Long> contentLength, byte[] content) {
        this.mContentType = contentType;
        this.mContentLength = contentLength;
        this.mContent = content;
    }

    public Optional<MediaType> contentType() {
        return this.mContentType;
    }

    public Optional<Long> contentLength() {
        return this.mContentLength;
    }

    public InputStream contentStream() {
        return new ByteArrayInputStream(this.mContent);
    }
}

