/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.mockutils.responses;

import java.net.URI;
import org.dmfs.httpessentials.HttpStatus;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseEntity;
import org.dmfs.httpessentials.headers.BasicSingletonHeaderType;
import org.dmfs.httpessentials.headers.EmptyHeaders;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.headers.HttpHeaders;
import org.dmfs.httpessentials.headers.SingletonHeaderType;
import org.dmfs.httpessentials.typedentity.EntityConverter;
import org.dmfs.httpessentials.types.MediaType;

public class StaticEntityMockResponse
implements HttpResponse {
    private static final SingletonHeaderType<Long> CONTENT_LENGTH = new BasicSingletonHeaderType("content-length", (EntityConverter)new EntityConverter<Long>(){

        public Long value(String valueString) {
            return Long.parseLong(valueString);
        }

        public String valueString(Long value) {
            return String.valueOf(value);
        }
    });
    private final HttpResponseEntity mEntity;

    public StaticEntityMockResponse(HttpResponseEntity entity) {
        this.mEntity = entity;
    }

    public HttpStatus status() {
        return HttpStatus.OK;
    }

    public Headers headers() {
        EmptyHeaders result = EmptyHeaders.INSTANCE;
        if (this.mEntity.contentType().isPresent()) {
            result = result.withHeader(HttpHeaders.CONTENT_TYPE.entity((Object)((MediaType)this.mEntity.contentType().value())));
        }
        if (this.mEntity.contentLength().isPresent()) {
            result = result.withHeader(CONTENT_LENGTH.entity((Object)((Long)this.mEntity.contentLength().value())));
        }
        return result;
    }

    public HttpResponseEntity responseEntity() {
        return this.mEntity;
    }

    public URI requestUri() {
        throw new UnsupportedOperationException("this response doesn't define a request uri, use a decorator for that");
    }

    public URI responseUri() {
        throw new UnsupportedOperationException("this response doesn't define a response uri, use a decorator for that");
    }
}

