/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.httpurlconnection;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.dmfs.httpessentials.client.HttpResponseEntity;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.httpessentials.types.StringMediaType;
import org.dmfs.jems.optional.Optional;
import org.dmfs.jems.optional.adapters.Conditional;
import org.dmfs.jems.optional.decorators.Mapped;
import org.dmfs.jems.optional.elementary.NullSafe;

final class HttpUrlConnectionResponseEntity
implements HttpResponseEntity {
    private final HttpURLConnection mConnection;

    public HttpUrlConnectionResponseEntity(HttpURLConnection connection) {
        this.mConnection = connection;
    }

    public Optional<MediaType> contentType() {
        return new Mapped(StringMediaType::new, (Optional)new NullSafe((Object)this.mConnection.getContentType()));
    }

    public Optional<Long> contentLength() {
        long length;
        try {
            length = this.mConnection.getContentLengthLong();
        }
        catch (NoSuchMethodError e) {
            length = this.mConnection.getContentLength();
        }
        return new Conditional(l -> l >= 0L, (Object)length);
    }

    public InputStream contentStream() throws IOException {
        if (this.mConnection.getResponseCode() < 400) {
            return this.mConnection.getInputStream();
        }
        return this.mConnection.getErrorStream();
    }
}

