/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dmfs.iterators.AbstractBaseIterator;

public abstract class AbstractFilteredIterator<E>
extends AbstractBaseIterator<E> {
    private final Iterator<E> mIterator;
    private final IteratorFilter<E> mFilter;
    private E mNext;
    private boolean mHasNext;

    public AbstractFilteredIterator(Iterator<E> iterator, IteratorFilter<E> filter) {
        this.mIterator = iterator;
        this.mFilter = filter;
        this.moveToNext();
    }

    @Override
    public final boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public final E next() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No more elements to iterate");
        }
        E result = this.mNext;
        this.moveToNext();
        return result;
    }

    private void moveToNext() {
        while (this.mIterator.hasNext()) {
            E next = this.mIterator.next();
            if (!this.mFilter.iterate(next)) continue;
            this.mNext = next;
            this.mHasNext = true;
            return;
        }
        this.mHasNext = false;
    }

    public static interface IteratorFilter<E> {
        public boolean iterate(E var1);
    }
}

