/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CsvIterator
implements Iterator<String> {
    private final String mValue;
    private final char mSeparator;
    private int mLastSeparatorPos = -1;
    private int mNextSeparatorPos = -1;

    public CsvIterator(String value, char separator) {
        this.mValue = value;
        this.mSeparator = separator;
    }

    @Override
    public boolean hasNext() {
        if (this.mNextSeparatorPos == -1) {
            this.findNextSeparator();
        }
        return this.mLastSeparatorPos < this.mValue.length();
    }

    @Override
    public String next() {
        if (this.mLastSeparatorPos >= this.mValue.length()) {
            throw new NoSuchElementException("Last element has already been iterated.");
        }
        if (this.mNextSeparatorPos == -1) {
            this.findNextSeparator();
        }
        String result = this.mValue.substring(this.mLastSeparatorPos + 1, this.mNextSeparatorPos);
        this.findNextSeparator();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported by this iterator");
    }

    private void findNextSeparator() {
        boolean isQuoted = false;
        this.mLastSeparatorPos = this.mNextSeparatorPos;
        while (++this.mNextSeparatorPos < this.mValue.length()) {
            char c = this.mValue.charAt(this.mNextSeparatorPos);
            if (c == this.mSeparator) {
                if (isQuoted) continue;
                return;
            }
            if (c != '\"') continue;
            isQuoted = !isQuoted;
        }
    }
}

