/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.iterator.composite;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dmfs.iterators.AbstractBaseIterator;
import org.dmfs.jems.function.BiFunction;
import org.dmfs.jems.optional.Optional;
import org.dmfs.jems.optional.adapters.Next;
import org.dmfs.jems.pair.Pair;
import org.dmfs.jems.pair.elementary.LeftSidedPair;
import org.dmfs.jems.pair.elementary.RightSidedPair;
import org.dmfs.jems.pair.elementary.ValuePair;

public final class Diff<Left, Right>
extends AbstractBaseIterator<Pair<? extends Optional<? extends Left>, ? extends Optional<? extends Right>>> {
    private final Iterator<? extends Left> mLefts;
    private final Iterator<? extends Right> mRights;
    private final BiFunction<? super Left, ? super Right, Integer> mComparatorFunction;
    private Optional<? extends Left> mNextLeft;
    private Optional<? extends Right> mNextRight;

    public Diff(Iterator<? extends Left> leftIterator, Iterator<? extends Right> rightIterator, BiFunction<? super Left, ? super Right, Integer> comparatorFunction) {
        this.mLefts = leftIterator;
        this.mRights = rightIterator;
        this.mComparatorFunction = comparatorFunction;
        this.mNextLeft = new Next<Left>(leftIterator);
        this.mNextRight = new Next<Right>(rightIterator);
    }

    @Override
    public boolean hasNext() {
        return this.mNextLeft.isPresent() || this.mNextRight.isPresent();
    }

    @Override
    public Pair<? extends Optional<? extends Left>, ? extends Optional<? extends Right>> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements to iterate");
        }
        if (!this.mNextLeft.isPresent()) {
            Optional<? extends Right> right = this.mNextRight;
            this.mNextRight = new Next<Right>(this.mRights);
            return new RightSidedPair(right);
        }
        if (!this.mNextRight.isPresent()) {
            Optional<? extends Left> left = this.mNextLeft;
            this.mNextLeft = new Next<Left>(this.mLefts);
            return new LeftSidedPair(left);
        }
        int result = this.mComparatorFunction.value(this.mNextLeft.value(), this.mNextRight.value());
        if (result < 0) {
            Optional<? extends Left> nextLeft = this.mNextLeft;
            this.mNextLeft = new Next<Left>(this.mLefts);
            return new LeftSidedPair(nextLeft);
        }
        if (result > 0) {
            Optional<? extends Right> nextRight = this.mNextRight;
            this.mNextRight = new Next<Right>(this.mRights);
            return new RightSidedPair(nextRight);
        }
        Optional<? extends Left> nextLeft = this.mNextLeft;
        Optional<? extends Right> nextRight = this.mNextRight;
        this.mNextLeft = new Next<Left>(this.mLefts);
        this.mNextRight = new Next<Right>(this.mRights);
        return new ValuePair<Optional<? extends Left>, Optional<? extends Right>>(nextLeft, nextRight);
    }
}

