/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.iterator.decorators;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import org.dmfs.jems.optional.Optional;
import org.dmfs.jems.optional.adapters.Next;
import org.dmfs.jems.optional.elementary.Absent;
import org.dmfs.jems.optional.elementary.Present;

public final class Clustered<T>
implements Iterator<Iterable<T>> {
    private final Iterator<T> mDelegate;
    private final Comparator<? super T> mComparator;
    private Optional<T> mNext;

    public Clustered(Comparator<? super T> comparator, Iterator<T> delegate) {
        this.mDelegate = delegate;
        this.mComparator = comparator;
        this.mNext = new Next<T>(this.mDelegate);
    }

    @Override
    public boolean hasNext() {
        return this.mNext.isPresent();
    }

    @Override
    public Iterable<T> next() {
        boolean hasMore;
        T first = this.mNext.value();
        LinkedList<T> result = new LinkedList<T>();
        result.add(first);
        Object next = null;
        while (hasMore = this.mDelegate.hasNext()) {
            T t = this.mDelegate.next();
            next = t;
            if (this.mComparator.compare(first, t) != 0) break;
            result.add(next);
        }
        this.mNext = hasMore ? new Present<Object>(next) : Absent.absent();
        return result;
    }
}

