/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.charsequence.elementary;

import java.util.Locale;

@Deprecated
public final class Hex
implements CharSequence {
    private static final char[] NIBBLES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final byte[] mBinaryData;
    private final int mStart;
    private final int mEnd;

    public Hex(byte[] binaryData) {
        this(0, binaryData.length * 2, binaryData);
    }

    public Hex(byte[] binaryData, int start, int end) {
        this(start * 2, end * 2, binaryData);
    }

    private Hex(int start, int end, byte[] binaryData) {
        this.mBinaryData = binaryData;
        this.mStart = start;
        this.mEnd = end;
    }

    @Override
    public int length() {
        return this.mEnd - this.mStart;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.mEnd - this.mStart) {
            throw new ArrayIndexOutOfBoundsException(String.format(Locale.ENGLISH, "Invalid index %d. Expected value between 0 and %d", index, this.mEnd - this.mStart));
        }
        return this.hex(index + this.mStart);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end < start || end > this.mEnd - this.mStart) {
            throw new ArrayIndexOutOfBoundsException("invalid range");
        }
        return new Hex(start + this.mStart, end + this.mStart, this.mBinaryData);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.mBinaryData.length * 2);
        for (int i = this.mStart; i < this.mEnd; ++i) {
            sb.append(this.hex(i));
        }
        return sb.toString();
    }

    private char hex(int index) {
        return NIBBLES[this.mBinaryData[index >> 1] >>> 4 - (index & 1) * 4 & 0xF];
    }
}

