/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.mockito;

import org.dmfs.jems2.FragileFunction;
import org.dmfs.jems2.FragileProcedure;
import org.dmfs.jems2.Function;
import org.dmfs.jems2.Generator;
import org.dmfs.jems2.Procedure;
import org.dmfs.jems2.iterable.Seq;
import org.dmfs.jems2.mockito.doubles.TestDoubles;
import org.dmfs.jems2.procedure.Composite;
import org.dmfs.jems2.single.Reduced;
import org.dmfs.jems2.single.Unchecked;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Stubber;

public final class Mock {
    @SafeVarargs
    public static <T> T mock(Class<T> clazz, Procedure<? super T> ... methods) {
        T result = TestDoubles.failingMock(clazz);
        new Composite(methods).process(result);
        return result;
    }

    @SafeVarargs
    public static <T> T update(T mock, Procedure<? super T> ... methods) {
        new Composite(methods).process(mock);
        return mock;
    }

    @SafeVarargs
    public static <T, V> Procedure<T> with(FragileFunction<? super T, ? extends V, ? extends Throwable> methodCall, StubGenerator<? extends V> stubGenerator, StubGenerator<? extends V> ... stubGenerators) {
        return mock -> new org.dmfs.jems2.function.Unchecked(methodCall).value(((Stubber)new Reduced((Generator)stubGenerator, (stubber, function) -> (Stubber)function.value(stubber), (Iterable)new Seq((Object[])stubGenerators)).value()).when(mock));
    }

    @SafeVarargs
    public static <T, V> Procedure<T> withVoid(FragileProcedure<? super T, ? extends Throwable> methodCall, StubGenerator<? extends V> stubGenerator, StubGenerator<? extends V> ... stubGenerators) {
        return mock -> new Unchecked(() -> {
            methodCall.process(((Stubber)new Reduced((Generator)stubGenerator, (stubber, function) -> (Stubber)function.value(stubber), (Iterable)new Seq((Object[])stubGenerators)).value()).when(mock));
            return null;
        }).value();
    }

    @SafeVarargs
    public static <T> StubGenerator<T> returning(final T value, final T ... values) {
        return new StubGenerator<T>(){

            public Stubber value(Stubber stubber) {
                return stubber.doReturn(value, values);
            }

            public Stubber next() {
                return Mockito.doReturn((Object)value, (Object[])values);
            }
        };
    }

    public static <T> StubGenerator<T> throwing(final Throwable ... exception) {
        return new StubGenerator<T>(){

            public Stubber value(Stubber stubber) {
                return stubber.doThrow(exception);
            }

            public Stubber next() {
                return Mockito.doThrow((Throwable[])exception);
            }
        };
    }

    public static <T> StubGenerator<T> answering(final Answer<T> answer) {
        return new StubGenerator<T>(){

            public Stubber value(Stubber stubber) {
                return stubber.doAnswer(answer);
            }

            public Stubber next() {
                return Mockito.doAnswer((Answer)answer);
            }
        };
    }

    public static <T> StubGenerator<T> doingNothing() {
        return new StubGenerator<T>(){

            public Stubber value(Stubber stubber) {
                return stubber.doNothing();
            }

            public Stubber next() {
                return Mockito.doNothing();
            }
        };
    }

    public static interface StubGenerator<T>
    extends Generator<Stubber>,
    Function<Stubber, Stubber> {
    }
}

