/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class ParallelMatcher<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final Matcher<T> mDelegate;
    private final int mNumThreads;

    public static <T> Matcher<T> parallel(int threads, Matcher<T> delegate) {
        return new ParallelMatcher<T>(threads, delegate);
    }

    public static <T> Matcher<T> parallel(Matcher<T> delegate) {
        return new ParallelMatcher<T>(delegate);
    }

    public ParallelMatcher(Matcher<T> delegate) {
        this(1000, delegate);
    }

    public ParallelMatcher(int threads, Matcher<T> delegate) {
        this.mDelegate = delegate;
        this.mNumThreads = threads;
    }

    protected boolean matchesSafely(T item, Description mismatchDescription) {
        ExecutorService executor = Executors.newFixedThreadPool(this.mNumThreads);
        Set results = Collections.synchronizedSet(new HashSet());
        for (int i = 0; i < this.mNumThreads; ++i) {
            executor.execute(() -> {
                if (!this.mDelegate.matches(item)) {
                    results.add(false);
                }
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        if (results.size() > 0) {
            mismatchDescription.appendText("at least one matcher failed");
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendDescriptionOf(this.mDelegate);
        description.appendText(String.format(Locale.ENGLISH, " every time when run %d times in parallel", this.mNumThreads));
    }
}

