/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.procedure;

import org.dmfs.jems2.Function;
import org.dmfs.jems2.Generator;
import org.dmfs.jems2.Procedure;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class ProcedureMatcher2<Param, Argument>
extends TypeSafeDiagnosingMatcher<Function<? super Param, ? extends Procedure<? super Argument>>> {
    private final Generator<Param> mParamGenerator;
    private final Argument mArgument;
    private final Matcher<? super Param> mDelegate;

    public static <Param, Argument> Matcher<Function<? super Param, ? extends Procedure<? super Argument>>> processes(Generator<Param> paramGenerator, Argument argument, Matcher<? super Param> delegate) {
        return new ProcedureMatcher2<Param, Argument>(paramGenerator, argument, delegate);
    }

    public ProcedureMatcher2(Generator<Param> paramGenerator, Argument argument, Matcher<? super Param> delegate) {
        this.mParamGenerator = paramGenerator;
        this.mArgument = argument;
        this.mDelegate = delegate;
    }

    protected boolean matchesSafely(Function<? super Param, ? extends Procedure<? super Argument>> item, Description mismatchDescription) {
        Object param = this.mParamGenerator.next();
        ((Procedure)item.value(param)).process(this.mArgument);
        if (!this.mDelegate.matches(param)) {
            mismatchDescription.appendText("processed parameter ");
            this.mDelegate.describeMismatch(param, mismatchDescription);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("processes ").appendValue(this.mParamGenerator.next()).appendText(" with ").appendValue(this.mArgument).appendText(" to ").appendDescriptionOf(this.mDelegate);
    }
}

