/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.charsequence;

import java.util.Locale;
import org.dmfs.jems2.hamcrest.matchers.charsequence.CharSequenceCharAtMatcher;
import org.dmfs.jems2.hamcrest.matchers.charsequence.CharSequenceLengthMatcher;
import org.dmfs.jems2.iterable.Seq;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.AllOf;

public final class CharSequenceSubSequenceMatcher
extends TypeSafeDiagnosingMatcher<CharSequence> {
    private final CharSequence mExpectedValue;
    private final int mSubSequenceTestDepth;

    public static CharSequenceSubSequenceMatcher hasSubSequences(CharSequence expectedValue, int subSequenceTestDepth) {
        return new CharSequenceSubSequenceMatcher(expectedValue, subSequenceTestDepth);
    }

    public CharSequenceSubSequenceMatcher(CharSequence expectedValue, int subSequenceTestDepth) {
        this.mExpectedValue = expectedValue;
        this.mSubSequenceTestDepth = subSequenceTestDepth;
    }

    protected boolean matchesSafely(CharSequence item, Description mismatchDescription) {
        if (this.mSubSequenceTestDepth == 0) {
            return true;
        }
        int max = this.mExpectedValue.length();
        for (int i = -max - 1; i <= max * 2 + 1; ++i) {
            for (int j = -max - 1; j <= max * 2 + 1; ++j) {
                if (i < 0 || j > max || j < i) {
                    try {
                        item.subSequence(i, j);
                        mismatchDescription.appendText(String.format(Locale.ENGLISH, "subSequence(%d, %d) did not throw", i, j));
                        return false;
                    }
                    catch (ArrayIndexOutOfBoundsException | StringIndexOutOfBoundsException indexOutOfBoundsException) {
                        continue;
                    }
                }
                String expected = this.mExpectedValue.subSequence(i, j).toString();
                AllOf subSequenceMatcher = new AllOf((Iterable)new Seq((Object[])new Matcher[]{Matchers.hasToString((String)expected), CharSequenceLengthMatcher.hasLength(expected.length()), CharSequenceCharAtMatcher.hasChars(expected), CharSequenceSubSequenceMatcher.hasSubSequences(expected, this.mSubSequenceTestDepth - 1)}));
                if (subSequenceMatcher.matches((Object)item.subSequence(i, j))) continue;
                mismatchDescription.appendText(String.format(Locale.ENGLISH, "subSequence(%d, %d) ", i, j));
                subSequenceMatcher.describeMismatch((Object)item.subSequence(i, j), mismatchDescription);
                return false;
            }
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("sub-sequences match \"").appendText(this.mExpectedValue.toString()).appendText("\"");
    }
}

