/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.generatable;

import org.dmfs.jems2.Generatable;
import org.dmfs.jems2.Generator;
import org.dmfs.jems2.iterable.Mapped;
import org.dmfs.jems2.iterable.Seq;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class GeneratableMatcher<T>
extends TypeSafeDiagnosingMatcher<Generatable<T>> {
    private final Iterable<Matcher<T>> mExpectedStartSequence;

    @SafeVarargs
    public static <T> Matcher<Generatable<T>> startsWith(T ... elements) {
        return new GeneratableMatcher<T>(new Mapped(CoreMatchers::is, (Iterable)new Seq((Object[])elements)));
    }

    @SafeVarargs
    public static <T> Matcher<Generatable<T>> startsWith(Matcher<T> ... elements) {
        return new GeneratableMatcher<T>(new Seq((Object[])elements));
    }

    public static <T> Matcher<Generatable<T>> startsWith(Iterable<Matcher<T>> elements) {
        return new GeneratableMatcher<T>(elements);
    }

    public GeneratableMatcher(Iterable<Matcher<T>> expectedStartSequence) {
        this.mExpectedStartSequence = expectedStartSequence;
    }

    protected boolean matchesSafely(Generatable<T> item, Description mismatchDescription) {
        int pos = 0;
        Generator generator = item.generator();
        for (Matcher<T> matcher : this.mExpectedStartSequence) {
            Object next;
            if (!matcher.matches(next = generator.next())) {
                mismatchDescription.appendText(String.format("element at position %d ", pos));
                matcher.describeMismatch(next, mismatchDescription);
                return false;
            }
            ++pos;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("Generatable with start sequence ");
        boolean first = true;
        for (Matcher<T> matcher : this.mExpectedStartSequence) {
            if (first) {
                first = false;
            } else {
                description.appendText(", ");
            }
            matcher.describeTo(description);
        }
    }
}

