/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.charsequence;

import java.util.Locale;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class CharSequenceLengthMatcher
extends TypeSafeDiagnosingMatcher<CharSequence> {
    private final int mExpectedValue;

    public static CharSequenceLengthMatcher hasLength(int expectedLength) {
        return new CharSequenceLengthMatcher(expectedLength);
    }

    public CharSequenceLengthMatcher(int expectedValue) {
        this.mExpectedValue = expectedValue;
    }

    protected boolean matchesSafely(CharSequence item, Description mismatchDescription) {
        if (item.length() != this.mExpectedValue) {
            mismatchDescription.appendText(String.format(Locale.ENGLISH, "had length %d", item.length()));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(String.format(Locale.ENGLISH, "has length %d", this.mExpectedValue));
    }
}

