/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.iterator;

import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.dmfs.jems2.Generator;
import org.dmfs.jems2.iterable.EmptyIterable;
import org.dmfs.jems2.iterable.Mapped;
import org.dmfs.jems2.iterable.Seq;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class IteratorMatcher<T>
extends TypeSafeDiagnosingMatcher<Generator<? extends Iterator<? extends T>>> {
    public static final int HAS_NEXT_TEST_COUNT = 100;
    public static final int EXCEPTION_TEST_COUNT = 100;
    private final Iterable<Matcher<? super T>> mElementMatchers;

    public static <T> Matcher<Generator<? extends Iterator<? extends T>>> emptyIterator() {
        return new IteratorMatcher<T>(new EmptyIterable());
    }

    @SafeVarargs
    public static <T> Matcher<Generator<? extends Iterator<? extends T>>> iteratorOf(T ... elements) {
        return new IteratorMatcher<T>(new Mapped(Matchers::equalTo, (Iterable)new Seq((Object[])elements)));
    }

    public static <T> Matcher<Generator<? extends Iterator<? extends T>>> iteratorOf(Iterable<Matcher<? super T>> elementMatchers) {
        return new IteratorMatcher<T>(elementMatchers);
    }

    @SafeVarargs
    public static <T> Matcher<Generator<? extends Iterator<? extends T>>> iteratorOf(Matcher<? super T> ... elementMatchers) {
        return new IteratorMatcher<T>(new Seq((Object[])elementMatchers));
    }

    public IteratorMatcher(Iterable<Matcher<? super T>> mElementMatchers) {
        this.mElementMatchers = mElementMatchers;
    }

    protected boolean matchesSafely(Generator<? extends Iterator<? extends T>> item, Description mismatchDescription) {
        int i;
        Iterator<Matcher<T>> matcherIterator = this.mElementMatchers.iterator();
        Iterator testee = (Iterator)item.next();
        int index = 0;
        while (testee.hasNext() && matcherIterator.hasNext()) {
            for (int i2 = 0; i2 < 100; ++i2) {
                if (!testee.hasNext()) {
                    mismatchDescription.appendText(String.format(Locale.ENGLISH, "hasNext() flipped at index %d", index));
                    return false;
                }
                try {
                    testee.remove();
                    mismatchDescription.appendText(String.format(Locale.ENGLISH, "remove() did not throw at index %d", index));
                    return false;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    continue;
                }
                catch (Exception e) {
                    mismatchDescription.appendText(String.format(Locale.ENGLISH, "remove() threw wrong exception at index %d", index));
                    return false;
                }
            }
            Object next = testee.next();
            Matcher<? super T> nextMatcher = matcherIterator.next();
            if (!nextMatcher.matches(next)) {
                nextMatcher.describeMismatch(next, mismatchDescription);
                mismatchDescription.appendText(String.format(Locale.ENGLISH, " at index %d", index));
                return false;
            }
            ++index;
        }
        if (testee.hasNext()) {
            mismatchDescription.appendText(String.format(Locale.ENGLISH, "had more than %d elements", index));
            return false;
        }
        for (i = 0; i < 100; ++i) {
            if (testee.hasNext()) {
                mismatchDescription.appendText("hasNext() flipped after the last element");
                return false;
            }
            try {
                testee.remove();
                mismatchDescription.appendText("remove() did not throw after last element");
                return false;
            }
            catch (UnsupportedOperationException nextMatcher) {
                continue;
            }
            catch (Exception e) {
                mismatchDescription.appendText("remove() threw wrong exception after last element");
                return false;
            }
        }
        if (matcherIterator.hasNext()) {
            mismatchDescription.appendText(String.format(Locale.ENGLISH, "had only %d elements", index));
            return false;
        }
        for (i = 0; i < 100; ++i) {
            try {
                testee.next();
                mismatchDescription.appendText("next() did not throw after hasNext() returned false");
                return false;
            }
            catch (NoSuchElementException e) {
                continue;
            }
            catch (Exception e) {
                mismatchDescription.appendText("next() threw wrong exception after hasNext() returned false");
                return false;
            }
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("iterator of [");
        boolean first = true;
        for (Matcher<? super T> matcher : this.mElementMatchers) {
            if (first) {
                first = false;
            } else {
                description.appendText(", ");
            }
            matcher.describeTo(description);
        }
        description.appendText("]");
    }
}

