/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.matcher;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class MismatchMatcher<V, T extends Matcher<? super V>>
extends TypeSafeDiagnosingMatcher<T> {
    private final V mMismatchItem;
    private final Matcher<? super String> mDescriptionMatcher;

    public MismatchMatcher(V mismatchItem, Matcher<? super String> descriptionMatcher) {
        this.mMismatchItem = mismatchItem;
        this.mDescriptionMatcher = descriptionMatcher;
    }

    protected boolean matchesSafely(T item, Description mismatchDescription) {
        if (item.matches(this.mMismatchItem)) {
            mismatchDescription.appendText(String.format("did match \"%s\"", this.mMismatchItem.toString()));
            return false;
        }
        StringDescription description = new StringDescription();
        item.describeMismatch(this.mMismatchItem, (Description)description);
        if (!this.mDescriptionMatcher.matches((Object)description.toString())) {
            mismatchDescription.appendText("description ");
            this.mDescriptionMatcher.describeMismatch((Object)description.toString(), mismatchDescription);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("mismatches with description ");
        this.mDescriptionMatcher.describeTo(description);
    }
}

