/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.mockito;

import org.dmfs.jems2.Function;
import org.dmfs.jems2.Procedure;
import org.dmfs.jems2.iterable.EmptyIterable;
import org.dmfs.jems2.iterable.Seq;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class MockInteractionMatcher<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final Function<T, InOrder> mOrderFactory;
    private final Iterable<? extends Procedure<? super T>> mTestProcedures;
    private final String mDescription;

    public static <T> Matcher<T> notCalled() {
        return new MockInteractionMatcher<T>(xva$0 -> Mockito.inOrder((Object[])new Object[]{xva$0}), new EmptyIterable(), "mock is not called");
    }

    @SafeVarargs
    public static <T> Matcher<T> called(Procedure<? super T> ... verifications) {
        return new MockInteractionMatcher<T>(x$0 -> new NoOrder(x$0), new Seq((Object[])verifications), "mock is called in any order");
    }

    @SafeVarargs
    public static <T> Matcher<T> calledInOrder(Procedure<? super T> ... verifications) {
        return new MockInteractionMatcher<T>(xva$0 -> Mockito.inOrder((Object[])new Object[]{xva$0}), new Seq((Object[])verifications), "mock is called in order");
    }

    public MockInteractionMatcher(Function<T, InOrder> mOrderFactory, Iterable<? extends Procedure<? super T>> mTestProcedures, String mDescription) {
        this.mOrderFactory = mOrderFactory;
        this.mTestProcedures = mTestProcedures;
        this.mDescription = mDescription;
    }

    protected boolean matchesSafely(T item, Description mismatchDescription) {
        InOrder inOrder = (InOrder)this.mOrderFactory.value(item);
        try {
            for (Procedure<? super T> procedure : this.mTestProcedures) {
                procedure.process(inOrder.verify(item));
            }
            inOrder.verifyNoMoreInteractions();
        }
        catch (AssertionError e) {
            mismatchDescription.appendText(((Throwable)((Object)e)).getMessage());
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(this.mDescription);
    }

    private static final class NoOrder<T>
    implements InOrder {
        private final T mMock;

        private NoOrder(T mock) {
            this.mMock = mock;
        }

        public <T> T verify(T mock) {
            return (T)Mockito.verify(mock);
        }

        public <T> T verify(T mock, VerificationMode mode) {
            return (T)Mockito.verify(mock, (VerificationMode)mode);
        }

        public void verifyNoMoreInteractions() {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mMock});
        }
    }
}

