/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.optional;

import org.dmfs.jems2.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.IsAnything;
import org.hamcrest.core.IsEqual;

public final class PresentMatcher<T>
extends TypeSafeDiagnosingMatcher<Optional<? extends T>> {
    private final Matcher<? super T> mDelegate;

    public PresentMatcher() {
        this((Matcher<T>)new IsAnything());
    }

    public PresentMatcher(T expected) {
        this((Matcher<T>)new IsEqual(expected));
    }

    public PresentMatcher(Matcher<? super T> delegate) {
        this.mDelegate = delegate;
    }

    public static <T> PresentMatcher<T> present() {
        return new PresentMatcher<T>();
    }

    public static <T> PresentMatcher<T> present(T expectedValue) {
        return new PresentMatcher<T>(Matchers.equalTo(expectedValue));
    }

    public static <T> PresentMatcher<T> present(Matcher<? super T> delegate) {
        return new PresentMatcher<T>(delegate);
    }

    protected boolean matchesSafely(Optional<? extends T> item, Description mismatchDescription) {
        if (!item.isPresent()) {
            mismatchDescription.appendText("not present");
            return false;
        }
        if (!this.mDelegate.matches(item.value())) {
            mismatchDescription.appendText("present, but value ");
            this.mDelegate.describeMismatch(item.value(), mismatchDescription);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("present with value ");
        this.mDelegate.describeTo(description);
    }
}

