/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.stack;

import org.dmfs.jems2.Stack;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class StackTopMatcher<E>
extends TypeSafeDiagnosingMatcher<Stack.StackTop<E>> {
    private final Matcher<E> mElementMatcher;
    private final Matcher<Stack<E>> mBottomMatcher;

    public static <E> Matcher<Stack.StackTop<E>> stackTop(Matcher<E> matcher, Matcher<Stack<E>> bottomMatcher) {
        return new StackTopMatcher<E>(matcher, bottomMatcher);
    }

    public StackTopMatcher(Matcher<E> matcher, Matcher<Stack<E>> bottomMatcher) {
        this.mElementMatcher = matcher;
        this.mBottomMatcher = bottomMatcher;
    }

    protected boolean matchesSafely(Stack.StackTop<E> item, Description mismatchDescription) {
        if (!this.mElementMatcher.matches(item.element())) {
            mismatchDescription.appendText("element ");
            this.mElementMatcher.describeMismatch(item.element(), mismatchDescription);
            return false;
        }
        if (!this.mBottomMatcher.matches((Object)item.bottom())) {
            mismatchDescription.appendText("bottom stack ");
            this.mBottomMatcher.describeMismatch((Object)item.bottom(), mismatchDescription);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("A StackTop with element value ");
        this.mElementMatcher.describeTo(description);
        description.appendText(" and bottom ");
        this.mBottomMatcher.describeTo(description);
    }
}

