/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.comparable;

import java.util.Comparator;
import org.dmfs.jems2.iterable.Seq;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class ComparableOrderMatcher<T>
extends TypeSafeDiagnosingMatcher<Comparator<T>> {
    private final Iterable<? extends T> mOrderedValues;

    @SafeVarargs
    public static <T> Matcher<Comparator<T>> imposesOrderOf(T ... orderedValues) {
        return new ComparableOrderMatcher<T>(new Seq((Object[])orderedValues));
    }

    public ComparableOrderMatcher(Iterable<? extends T> orderedValues) {
        this.mOrderedValues = orderedValues;
    }

    protected boolean matchesSafely(Comparator<T> item, Description mismatchDescription) {
        int leftIdx = 0;
        for (T left : this.mOrderedValues) {
            int rightIdx = 0;
            for (T right : this.mOrderedValues) {
                if (leftIdx == rightIdx) {
                    if (item.compare(left, right) != 0) {
                        mismatchDescription.appendText("compared ").appendValue(left).appendText(" at index " + leftIdx).appendText(" to be non equal to itself (" + item.compare(left, right) + ")");
                        return false;
                    }
                } else if (leftIdx < rightIdx) {
                    if (item.compare(left, right) >= 0) {
                        mismatchDescription.appendText("compared elements ").appendValue(left).appendText(" at index " + leftIdx + " and ").appendValue(right).appendText(" at index " + rightIdx + " ").appendText(" in the wrong order (" + item.compare(left, right) + ")");
                        return false;
                    }
                } else if (item.compare(left, right) <= 0) {
                    mismatchDescription.appendText("compared elements ").appendValue(left).appendText(" at index " + leftIdx + " and ").appendValue(right).appendText(" at index " + rightIdx + " ").appendText(" in the wrong order (" + item.compare(left, right) + ")");
                    return false;
                }
                ++rightIdx;
            }
            ++leftIdx;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendValueList("imposes the following element order ", ",", "", this.mOrderedValues);
    }
}

