/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.function;

import org.dmfs.jems2.FragileFunction;
import org.dmfs.jems2.hamcrest.matchers.LambdaMatcher;
import org.dmfs.jems2.hamcrest.matchers.fragile.BrokenFragileMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class FragileFunctionMatcher<Argument, Result>
extends TypeSafeDiagnosingMatcher<FragileFunction<? super Argument, ? extends Result, ?>> {
    private final Argument mArgument;
    private final Matcher<? super Result> mResultMatcher;

    public static <Argument, Result> Matcher<FragileFunction<? super Argument, ? extends Result, ?>> throwing(Argument argument, Matcher<? super Throwable> throwableMatcher) {
        return LambdaMatcher.having("value Fragile", testee -> () -> testee.value(argument), Matchers.is(BrokenFragileMatcher.throwing(throwableMatcher)));
    }

    public static <Argument, Result> Matcher<FragileFunction<? super Argument, ? extends Result, ?>> associates(Argument argument, Result result) {
        return new FragileFunctionMatcher<Argument, Result>(argument, Matchers.is(result));
    }

    public static <Argument, Result> Matcher<FragileFunction<? super Argument, ? extends Result, ?>> associates(Argument argument, Matcher<? super Result> resultMatcher) {
        return new FragileFunctionMatcher<Argument, Result>(argument, resultMatcher);
    }

    public FragileFunctionMatcher(Argument mArgument, Matcher<? super Result> mResultMatcher) {
        this.mArgument = mArgument;
        this.mResultMatcher = mResultMatcher;
    }

    protected boolean matchesSafely(FragileFunction<? super Argument, ? extends Result, ?> item, Description mismatchDescription) {
        Object result = null;
        try {
            result = item.value(this.mArgument);
        }
        catch (Throwable throwable) {
            mismatchDescription.appendText(String.format("threw %s for argument %s", throwable, this.mArgument));
            return false;
        }
        if (!this.mResultMatcher.matches(result)) {
            mismatchDescription.appendText(String.format("result for argument %s ", this.mArgument));
            this.mResultMatcher.describeMismatch(result, mismatchDescription);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(String.format("result for argument %s ", this.mArgument)).appendDescriptionOf(this.mResultMatcher);
    }
}

