/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.single;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Locale;
import org.dmfs.jems2.BiFunction;
import org.dmfs.jems2.Fragile;
import org.dmfs.jems2.Generator;
import org.dmfs.jems2.Single;
import org.dmfs.jems2.function.SingleFunction;
import org.dmfs.jems2.iterable.Mapped;
import org.dmfs.jems2.iterable.Seq;
import org.dmfs.jems2.single.Just;
import org.dmfs.jems2.single.Reduced;

public final class Digest
implements Single<byte[]> {
    private final Generator<? extends MessageDigest> mMessageDigestGenerator;
    private final Iterable<? extends Fragile<byte[], ? extends RuntimeException>> mParts;
    private static final BiFunction<MessageDigest, Fragile<byte[], ? extends RuntimeException>, MessageDigest> DIGEST_ACCUMULATOR_FUNCTION = (messageDigest, bytes) -> {
        messageDigest.update((byte[])bytes.value());
        return messageDigest;
    };

    public Digest(Generator<? extends MessageDigest> messageDigestGenerator, byte[] ... parts) {
        this(messageDigestGenerator, new Mapped(SingleFunction.toSingle(), new Seq((T[])parts)));
    }

    public Digest(Generator<? extends MessageDigest> messageDigestGenerator, CharSequence ... parts) {
        this(messageDigestGenerator, "UTF-8", parts);
    }

    public Digest(Generator<? extends MessageDigest> messageDigestGenerator, String encoding, CharSequence ... parts) {
        this(messageDigestGenerator, new Mapped<CharSequence, Just>(bytes -> {
            try {
                return new Just<byte[]>(bytes.toString().getBytes(encoding));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(String.format(Locale.ENGLISH, "%s encoding not supported by runtime", encoding), e);
            }
        }, new Seq<CharSequence>(parts)));
    }

    @SafeVarargs
    public Digest(Generator<? extends MessageDigest> messageDigestGenerator, Fragile<byte[], ? extends RuntimeException> ... parts) {
        this(messageDigestGenerator, new Seq<Fragile<byte[], ? extends RuntimeException>>(parts));
    }

    public Digest(Generator<? extends MessageDigest> messageDigestGenerator, Iterable<? extends Fragile<byte[], ? extends RuntimeException>> parts) {
        this.mMessageDigestGenerator = messageDigestGenerator;
        this.mParts = parts;
    }

    @Override
    public byte[] value() {
        return new Reduced<Fragile<byte[], ? extends RuntimeException>, MessageDigest>(this.mMessageDigestGenerator, DIGEST_ACCUMULATOR_FUNCTION, this.mParts).value().digest();
    }
}

