/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.iterable;

import java.util.Iterator;
import org.dmfs.jems2.BiFunction;
import org.dmfs.jems2.Optional;
import org.dmfs.jems2.optional.Absent;
import org.dmfs.jems2.optional.Present;

public final class LeftZipped<Left, Right, Result>
implements Iterable<Result> {
    private final Iterable<? extends Left> mLeft;
    private final Iterable<? extends Right> mRight;
    private final BiFunction<? super Left, ? super Optional<? extends Right>, ? extends Result> mZipFunction;

    public LeftZipped(Iterable<? extends Left> left, Iterable<? extends Right> right, BiFunction<? super Left, ? super Optional<? extends Right>, ? extends Result> zipFunction) {
        this.mLeft = left;
        this.mRight = right;
        this.mZipFunction = zipFunction;
    }

    @Override
    public Iterator<Result> iterator() {
        final Iterator<? extends Left> left = this.mLeft.iterator();
        final Iterator<? extends Right> right = this.mRight.iterator();
        return new Iterator<Result>(){

            @Override
            public boolean hasNext() {
                return left.hasNext();
            }

            @Override
            public Result next() {
                return LeftZipped.this.mZipFunction.value(left.next(), right.hasNext() ? new Present(right.next()) : Absent.absent());
            }
        };
    }
}

