/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.iterator;

import java.util.NoSuchElementException;
import org.dmfs.jems2.iterator.BaseIterator;

public final class Seq<E>
extends BaseIterator<E> {
    private final E[] mValues;
    private final int mCount;
    private int mNext;

    @SafeVarargs
    public Seq(E ... values) {
        this(values.length, values);
    }

    public Seq(int count, E[] values) {
        if (count < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("Count must not be less than 0, was %d", count));
        }
        if (count > values.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("Count must not be higher than the number of values (%d), was %d", values.length, count));
        }
        this.mCount = count;
        this.mValues = values;
    }

    @Override
    public boolean hasNext() {
        return this.mNext < this.mCount;
    }

    @Override
    public E next() {
        int next = this.mNext;
        if (next >= this.mCount) {
            throw new NoSuchElementException("No more elements to iterate");
        }
        this.mNext = next + 1;
        return this.mValues[next];
    }
}

