/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByFilter;
import org.dmfs.rfc5545.recur.LongArray;
import org.dmfs.rfc5545.recur.RuleIterator;

abstract class ByExpander
extends RuleIterator {
    private static final int MAX_EMPTY_SETS = 1000;
    private final long mStart;
    private LongArray mWorkingSet = null;
    private final LongArray mResultSet = new LongArray();
    final CalendarMetrics mCalendarMetrics;
    private final ByFilter[] mFilters = new ByFilter[8];
    int mFilterCount = 0;

    public ByExpander(RuleIterator previous, CalendarMetrics calendarTools, long start) {
        super(previous);
        this.mStart = start;
        this.mCalendarMetrics = calendarTools;
    }

    @Override
    public long next() {
        LongArray workingSet = this.mWorkingSet;
        if (workingSet == null || !workingSet.hasNext()) {
            this.mWorkingSet = workingSet = this.nextSet();
        }
        return workingSet.next();
    }

    @Override
    LongArray nextSet() {
        LongArray resultSet = this.mResultSet;
        RuleIterator previous = this.mPrevious;
        long start = this.mStart;
        resultSet.clear();
        int counter = 0;
        do {
            if (counter == 1000) {
                throw new IllegalArgumentException("too many empty recurrence sets " + this);
            }
            ++counter;
            LongArray prev = previous.nextSet();
            while (prev.hasNext()) {
                this.expand(prev.next(), start);
            }
        } while (!resultSet.hasNext());
        resultSet.sort();
        return resultSet;
    }

    final void addFilter(ByFilter filter) {
        this.mFilters[this.mFilterCount++] = filter;
    }

    final void addInstance(long instance) {
        if (this.mFilterCount == 0 || !this.filter(instance)) {
            this.mResultSet.add(instance);
        }
    }

    final boolean filter(long instance) {
        ByFilter[] filters = this.mFilters;
        int count = this.mFilterCount;
        for (int i = 0; i < count; ++i) {
            if (!filters[i].filter(instance)) continue;
            return true;
        }
        return false;
    }

    abstract void expand(long var1, long var3);

    @Override
    void fastForward(long untilInstance) {
        untilInstance = Instance.maskWeekday((long)untilInstance);
        LongArray workingSet = this.mWorkingSet;
        if (workingSet != null) {
            while (workingSet.hasNext() && Instance.maskWeekday((long)workingSet.peek()) < untilInstance) {
                workingSet.next();
            }
        }
        if (workingSet == null || !workingSet.hasNext()) {
            this.mPrevious.fastForward(untilInstance);
        }
    }

    protected static enum Scope {
        WEEKLY,
        MONTHLY,
        WEEKLY_AND_MONTHLY,
        YEARLY;

    }
}

