/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByMonthDayWeeklyExpander
extends ByExpander {
    private final int[] mMonthDays;

    public ByMonthDayWeeklyExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start) {
        super(previous, calendarTools, start);
        this.mMonthDays = StaticUtils.ListToSortedArray(rule.getByPart(RecurrenceRule.Part.BYMONTHDAY));
    }

    @Override
    void expand(long instance, long start) {
        CalendarMetrics calendarMetrics = this.mCalendarMetrics;
        int year = Instance.year((long)instance);
        int month = Instance.month((long)instance);
        int dayOfMonth = Instance.dayOfMonth((long)instance);
        int weekOfYear = 0;
        int hour = Instance.hour((long)instance);
        int minute = Instance.minute((long)instance);
        int second = Instance.second((long)instance);
        int prevMonthDays = 0;
        int nextMonthDays = 0;
        weekOfYear = calendarMetrics.getWeekOfYear(year, month, dayOfMonth);
        prevMonthDays = month == 0 ? calendarMetrics.getDaysPerPackedMonth(year - 1, calendarMetrics.getMonthsPerYear(year - 1) - 1) : calendarMetrics.getDaysPerPackedMonth(year, month - 1);
        nextMonthDays = month == calendarMetrics.getMonthsPerYear(year) - 1 ? calendarMetrics.getDaysPerPackedMonth(year + 1, 0) : calendarMetrics.getDaysPerPackedMonth(year, month + 1);
        int monthDays = calendarMetrics.getDaysPerPackedMonth(year, month);
        int[] nArray = this.mMonthDays;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int day;
            int actualDay = day = nArray[i];
            if (day < 0) {
                actualDay = day + monthDays + 1;
            }
            int prevMonthDay = day;
            int nextMonthDay = day;
            if (day < 0) {
                prevMonthDay = day + prevMonthDays + 1;
                nextMonthDay = day + nextMonthDays + 1;
            }
            if (0 < actualDay && actualDay <= monthDays && calendarMetrics.getWeekOfYear(year, month, actualDay) == weekOfYear) {
                this.addInstance(Instance.make((int)year, (int)month, (int)actualDay, (int)hour, (int)minute, (int)second));
                continue;
            }
            if (0 < nextMonthDay && nextMonthDay <= nextMonthDays && nextMonthDay < 7) {
                if (month < calendarMetrics.getMonthsPerYear(year) - 1) {
                    if (calendarMetrics.getWeekOfYear(year, month + 1, nextMonthDay) != weekOfYear) continue;
                    this.addInstance(Instance.make((int)year, (int)(month + 1), (int)nextMonthDay, (int)hour, (int)minute, (int)second));
                    continue;
                }
                if (calendarMetrics.getWeekOfYear(year + 1, 0, nextMonthDay) != weekOfYear) continue;
                this.addInstance(Instance.make((int)(year + 1), (int)0, (int)nextMonthDay, (int)hour, (int)minute, (int)second));
                continue;
            }
            if (0 >= prevMonthDay || prevMonthDay > prevMonthDays || prevMonthDay <= prevMonthDays - 7) continue;
            if (month > 0) {
                if (calendarMetrics.getWeekOfYear(year, month - 1, prevMonthDay) != weekOfYear) continue;
                this.addInstance(Instance.make((int)year, (int)(month - 1), (int)prevMonthDay, (int)hour, (int)minute, (int)second));
                continue;
            }
            if (calendarMetrics.getWeekOfYear(year - 1, calendarMetrics.getMonthsPerYear(year - 1) - 1, prevMonthDay) != weekOfYear) continue;
            this.addInstance(Instance.make((int)(year - 1), (int)(calendarMetrics.getMonthsPerYear(year - 1) - 1), (int)prevMonthDay, (int)hour, (int)minute, (int)second));
        }
    }
}

