/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;

public enum Freq {
    YEARLY{

        @Override
        long next(CalendarMetrics calendarMetrics, long packedInstance, int interval) {
            return Instance.setYear((long)packedInstance, (int)(Instance.year((long)packedInstance) + interval));
        }

        @Override
        long next(CalendarMetrics calendarMetrics, long packedInstance, int interval, long minInstance) {
            int nextYear;
            int untilYear = Instance.year((long)minInstance);
            if (untilYear <= (nextYear = Instance.year((long)packedInstance))) {
                return packedInstance;
            }
            return Instance.setYear((long)packedInstance, (int)(nextYear + ((untilYear - nextYear - 1) / interval + 1) * interval));
        }
    }
    ,
    MONTHLY{

        @Override
        long next(CalendarMetrics calendarMetrics, long packedInstance, int interval) {
            if (interval == 1) {
                return calendarMetrics.nextMonth(packedInstance);
            }
            return calendarMetrics.nextMonth(packedInstance, interval);
        }
    }
    ,
    WEEKLY{

        @Override
        long next(CalendarMetrics calendarMetrics, long packedInstance, int interval) {
            return calendarMetrics.nextDay(packedInstance, interval * 7);
        }
    }
    ,
    DAILY{

        @Override
        long next(CalendarMetrics calendarMetrics, long packedInstance, int interval) {
            if (interval == 1) {
                return calendarMetrics.nextDay(packedInstance);
            }
            return calendarMetrics.nextDay(packedInstance, interval);
        }
    }
    ,
    HOURLY{

        @Override
        long next(CalendarMetrics calendarMetrics, long packedInstance, int interval) {
            int nextHour = Instance.hour((long)packedInstance) + interval;
            if (nextHour > 23) {
                packedInstance = DAILY.next(calendarMetrics, packedInstance, nextHour / 24);
                nextHour %= 24;
            }
            return Instance.setHour((long)packedInstance, (int)nextHour);
        }
    }
    ,
    MINUTELY{

        @Override
        long next(CalendarMetrics calendarMetrics, long packedInstance, int interval) {
            int nextMinute = Instance.minute((long)packedInstance) + interval;
            if (nextMinute > 59) {
                packedInstance = HOURLY.next(calendarMetrics, packedInstance, nextMinute / 60);
                nextMinute %= 60;
            }
            return Instance.setMinute((long)packedInstance, (int)nextMinute);
        }
    }
    ,
    SECONDLY{

        @Override
        long next(CalendarMetrics calendarMetrics, long packedInstance, int interval) {
            int nextSecond = Instance.second((long)packedInstance) + interval;
            if (nextSecond > 59) {
                packedInstance = MINUTELY.next(calendarMetrics, packedInstance, nextSecond / 60);
                nextSecond %= 60;
            }
            return Instance.setSecond((long)packedInstance, (int)nextSecond);
        }
    };


    abstract long next(CalendarMetrics var1, long var2, int var4);

    long next(CalendarMetrics calendarMetrics, long packedInstance, int interval, long minInstance) {
        long upcomingInstance = packedInstance;
        while (upcomingInstance < minInstance) {
            packedInstance = upcomingInstance;
            upcomingInstance = this.next(calendarMetrics, packedInstance, interval);
        }
        return packedInstance;
    }
}

