/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recurrenceset;

import java.util.List;
import java.util.Locale;
import org.dmfs.rfc5545.recurrenceset.AbstractRecurrenceAdapter;
import org.dmfs.rfc5545.recurrenceset.CompositeIterator;
import org.dmfs.rfc5545.recurrenceset.EmptyIterator;

public class RecurrenceSetIterator {
    private static final int MAX_SKIPPED_INSTANCES = 1000;
    private final AbstractRecurrenceAdapter.InstanceIterator mInstances;
    private final AbstractRecurrenceAdapter.InstanceIterator mExceptions;
    private long mIterateEnd = Long.MAX_VALUE;
    private long mNextInstance = Long.MIN_VALUE;
    private long mNextException = Long.MIN_VALUE;

    RecurrenceSetIterator(List<AbstractRecurrenceAdapter.InstanceIterator> instances, List<AbstractRecurrenceAdapter.InstanceIterator> exceptions) {
        AbstractRecurrenceAdapter.InstanceIterator instanceIterator = this.mInstances = instances.size() == 1 ? instances.get(0) : new CompositeIterator(instances);
        this.mExceptions = exceptions == null || exceptions.isEmpty() ? new EmptyIterator() : (exceptions.size() == 1 ? exceptions.get(0) : new CompositeIterator(exceptions));
        this.pullNext();
    }

    RecurrenceSetIterator setEnd(long end) {
        this.mIterateEnd = end;
        return this;
    }

    public boolean hasNext() {
        return this.mNextInstance < this.mIterateEnd;
    }

    public long next() {
        if (!this.hasNext()) {
            throw new ArrayIndexOutOfBoundsException("no more elements");
        }
        long result = this.mNextInstance;
        this.pullNext();
        return result;
    }

    public void fastForward(long until) {
        if (this.mNextInstance < until) {
            this.mInstances.fastForward(until);
            this.mExceptions.fastForward(until);
            this.pullNext();
        }
    }

    private void pullNext() {
        long next = Long.MAX_VALUE;
        long nextException = this.mNextException;
        int skipableInstances = 1000;
        while (this.mInstances.hasNext()) {
            next = this.mInstances.next();
            while (nextException < next) {
                nextException = this.mExceptions.hasNext() ? this.mExceptions.next() : Long.MAX_VALUE;
            }
            if (nextException > next) break;
            if (--skipableInstances <= 0) {
                throw new RuntimeException(String.format(Locale.ENGLISH, "Skipped too many (%d) instances", 1000));
            }
            next = Long.MAX_VALUE;
        }
        this.mNextInstance = next;
        this.mNextException = nextException;
    }
}

