/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.iterable.instanceiterable;

import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.iterable.InstanceIterable;
import org.dmfs.rfc5545.iterable.InstanceIterator;
import org.dmfs.rfc5545.iterable.instanceiterable.Composite;

public final class FastForwarded
implements InstanceIterable {
    private final long mTimeStamp;
    private final InstanceIterable mDelegate;

    public FastForwarded(DateTime fastForwardTo, InstanceIterable delegate) {
        this(fastForwardTo.getTimestamp(), delegate);
    }

    public FastForwarded(DateTime fastForwardTo, InstanceIterable ... delegate) {
        this(fastForwardTo.getTimestamp(), (InstanceIterable)new Composite(delegate));
    }

    public FastForwarded(DateTime fastForwardTo, Iterable<InstanceIterable> delegate) {
        this(fastForwardTo.getTimestamp(), (InstanceIterable)new Composite(delegate));
    }

    public FastForwarded(long timeStamp, InstanceIterable delegate) {
        this.mTimeStamp = timeStamp;
        this.mDelegate = delegate;
    }

    @Override
    public InstanceIterator iterator(DateTime firstInstance) {
        InstanceIterator iterator = this.mDelegate.iterator(firstInstance);
        if (firstInstance.getTimestamp() < this.mTimeStamp) {
            iterator.fastForward(this.mTimeStamp);
        }
        return iterator;
    }
}

