/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.http.requests;

import org.dmfs.httpessentials.client.HttpRequestEntity;
import org.dmfs.oauth2.client.OAuth2AuthCodeAuthorization;
import org.dmfs.oauth2.client.http.entities.XWwwFormUrlEncodedEntity;
import org.dmfs.oauth2.client.http.requests.AbstractAccessTokenRequest;
import org.dmfs.oauth2.client.utils.Parameters;
import org.dmfs.rfc3986.Uri;

public final class AuthorizationCodeTokenRequest
extends AbstractAccessTokenRequest {
    private final OAuth2AuthCodeAuthorization mAuthorization;
    private final Uri mRedirectUri;
    private final CharSequence mCodeVerifier;

    public AuthorizationCodeTokenRequest(OAuth2AuthCodeAuthorization authorization, Uri redirectUri, CharSequence codeVerifier) {
        super(authorization.scope());
        this.mAuthorization = authorization;
        this.mRedirectUri = redirectUri;
        this.mCodeVerifier = codeVerifier;
    }

    public HttpRequestEntity requestEntity() {
        return new XWwwFormUrlEncodedEntity(Parameters.GRANT_TYPE.parameter((Object)"authorization_code"), Parameters.AUTH_CODE.parameter((Object)this.mAuthorization.code()), Parameters.REDIRECT_URI.parameter((Object)this.mRedirectUri), Parameters.CODE_VERIFIER.parameter((Object)this.mCodeVerifier));
    }
}

