/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client;

import java.io.IOException;
import java.net.URI;
import java.security.SecureRandom;
import org.dmfs.httpessentials.client.HttpRequest;
import org.dmfs.httpessentials.client.HttpRequestExecutor;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.exceptions.RedirectionException;
import org.dmfs.httpessentials.exceptions.UnexpectedStatusException;
import org.dmfs.httpessentials.executors.useragent.Branded;
import org.dmfs.httpessentials.types.Product;
import org.dmfs.httpessentials.types.VersionedProduct;
import org.dmfs.oauth2.client.OAuth2AccessToken;
import org.dmfs.oauth2.client.OAuth2AuthorizationProvider;
import org.dmfs.oauth2.client.OAuth2AuthorizationRequest;
import org.dmfs.oauth2.client.OAuth2Client;
import org.dmfs.oauth2.client.OAuth2ClientCredentials;
import org.dmfs.rfc3986.Uri;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.Precoded;
import org.dmfs.rfc3986.uris.LazyUri;
import org.dmfs.rfc5545.Duration;

public final class BasicOAuth2Client
implements OAuth2Client {
    private static final String STATE_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-";
    private static final Product PRODUCT = new VersionedProduct("oauth2-essentials", "0.18");
    private final OAuth2AuthorizationProvider mProvider;
    private final OAuth2ClientCredentials mCredentials;
    private final Uri mRedirectUri;

    public BasicOAuth2Client(OAuth2AuthorizationProvider provider, OAuth2ClientCredentials credentials, URI redirectUri) {
        this(provider, credentials, (Uri)new LazyUri((UriEncoded)new Precoded((CharSequence)(redirectUri == null ? "" : redirectUri.toString()))));
    }

    public BasicOAuth2Client(OAuth2AuthorizationProvider provider, OAuth2ClientCredentials credentials, Uri redirectUri) {
        this.mProvider = provider;
        this.mCredentials = credentials;
        this.mRedirectUri = redirectUri;
    }

    @Override
    public OAuth2AccessToken accessToken(HttpRequest<OAuth2AccessToken> tokenRequest, HttpRequestExecutor executor) throws RedirectionException, UnexpectedStatusException, IOException, ProtocolError, ProtocolException {
        return this.mProvider.accessToken(this.mCredentials.authenticatedRequest(tokenRequest), (HttpRequestExecutor)new Branded(executor, PRODUCT));
    }

    @Override
    public URI authorizationUrl(OAuth2AuthorizationRequest authorizationRequest) {
        return this.mProvider.authorizationUrl(authorizationRequest.withClientId(this.mCredentials.clientId()).withRedirectUri(this.mRedirectUri));
    }

    @Override
    public Uri redirectUri() {
        return this.mRedirectUri;
    }

    @Override
    public Duration defaultTokenTtl() {
        return this.mProvider.defaultTokenTtl();
    }

    @Override
    public CharSequence randomChars() {
        StringBuilder result = new StringBuilder(64);
        SecureRandom random = new SecureRandom();
        int count = result.capacity();
        for (int i = 0; i < count; ++i) {
            result.append(STATE_CHARS.charAt(random.nextInt(STATE_CHARS.length())));
        }
        return result.toString();
    }
}

