/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.scope;

import org.dmfs.oauth2.client.OAuth2Scope;

public final class BasicScope
implements OAuth2Scope {
    private final String[] mTokens;

    public BasicScope(String ... tokens) {
        this.mTokens = (String[])tokens.clone();
    }

    @Override
    public boolean isEmpty() {
        return this.mTokens.length == 0;
    }

    @Override
    public boolean hasToken(String token) {
        for (String scopeToken : this.mTokens) {
            if (!scopeToken.equals(token)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int tokenCount() {
        return this.mTokens.length;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(this.mTokens.length * 30);
        boolean first = true;
        for (String token : this.mTokens) {
            if (first) {
                first = false;
            } else {
                result.append(' ');
            }
            result.append(token);
        }
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OAuth2Scope)) {
            return false;
        }
        OAuth2Scope other = (OAuth2Scope)obj;
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        if (this.tokenCount() != other.tokenCount()) {
            return false;
        }
        for (String token : this.mTokens) {
            if (other.hasToken(token)) continue;
            return false;
        }
        return true;
    }
}

