/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client;

import java.net.URI;
import java.net.URISyntaxException;
import org.dmfs.oauth2.client.OAuth2AuthorizationRequest;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.pkce.PkceCodeChallenge;
import org.dmfs.oauth2.client.utils.Parameters;
import org.dmfs.rfc3986.Uri;
import org.dmfs.rfc3986.encoding.XWwwFormUrlEncoded;
import org.dmfs.rfc3986.parameters.FluentParameterList;
import org.dmfs.rfc3986.parameters.Parameter;
import org.dmfs.rfc3986.parameters.ParameterList;
import org.dmfs.rfc3986.parameters.parametersets.BasicParameterList;
import org.dmfs.rfc3986.parameters.parametersets.Fluent;
import org.dmfs.rfc3986.parameters.parametersets.Replacing;

public final class BasicOAuth2AuthorizationRequest
implements OAuth2AuthorizationRequest {
    private final FluentParameterList mParameters;

    public BasicOAuth2AuthorizationRequest(String responseType, CharSequence state) {
        this((FluentParameterList)new Fluent((ParameterList)new BasicParameterList(new Parameter[]{Parameters.RESPONSE_TYPE.parameter((Object)responseType), Parameters.STATE.parameter((Object)state)})));
    }

    public BasicOAuth2AuthorizationRequest(String responseType, CharSequence state, ParameterList customParameters) {
        this((FluentParameterList)new Fluent((ParameterList)new Replacing(customParameters, new Parameter[]{Parameters.RESPONSE_TYPE.parameter((Object)responseType), Parameters.STATE.parameter((Object)state)})));
    }

    public BasicOAuth2AuthorizationRequest(String responseType, OAuth2Scope scope, CharSequence state) {
        this((FluentParameterList)new Fluent((ParameterList)new BasicParameterList(new Parameter[]{Parameters.RESPONSE_TYPE.parameter((Object)responseType), Parameters.SCOPE.parameter((Object)scope), Parameters.STATE.parameter((Object)state)})));
    }

    public BasicOAuth2AuthorizationRequest(String responseType, OAuth2Scope scope, CharSequence state, ParameterList customParameters) {
        this((FluentParameterList)new Fluent((ParameterList)new Replacing(customParameters, new Parameter[]{Parameters.RESPONSE_TYPE.parameter((Object)responseType), Parameters.SCOPE.parameter((Object)scope), Parameters.STATE.parameter((Object)state)})));
    }

    private BasicOAuth2AuthorizationRequest(FluentParameterList parameters) {
        this.mParameters = parameters;
    }

    @Override
    public OAuth2AuthorizationRequest withClientId(String clientId) {
        return new BasicOAuth2AuthorizationRequest(this.mParameters.ratherWith(new Parameter[]{Parameters.CLIENT_ID.parameter((Object)clientId)}));
    }

    @Override
    public OAuth2AuthorizationRequest withRedirectUri(Uri redirectUri) {
        return new BasicOAuth2AuthorizationRequest(this.mParameters.ratherWith(new Parameter[]{Parameters.REDIRECT_URI.parameter((Object)redirectUri)}));
    }

    @Override
    public OAuth2AuthorizationRequest withCodeChallenge(PkceCodeChallenge codeChallenge) {
        return new BasicOAuth2AuthorizationRequest(this.mParameters.ratherWith(new Parameter[]{Parameters.CODE_CHALLENGE_METHOD.parameter((Object)codeChallenge.method()), Parameters.CODE_CHALLENGE.parameter((Object)codeChallenge.challenge())}));
    }

    @Override
    public URI authorizationUri(URI authorizationEndpoint) {
        try {
            return URI.create(new URI(authorizationEndpoint.getScheme(), authorizationEndpoint.getAuthority(), authorizationEndpoint.getPath(), null, null) + "?" + new XWwwFormUrlEncoded((ParameterList)this.mParameters).toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Can't create valid authorization URI", e);
        }
    }
}

