/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.grants;

import java.io.IOException;
import org.dmfs.httpessentials.client.HttpRequestExecutor;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.oauth2.client.OAuth2AccessToken;
import org.dmfs.oauth2.client.OAuth2Client;
import org.dmfs.oauth2.client.OAuth2Grant;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.http.requests.ResourceOwnerPasswordTokenRequest;

public final class ResourceOwnerPasswordGrant
implements OAuth2Grant {
    private final OAuth2Client mClient;
    private final OAuth2Scope mScope;
    private final CharSequence mUsername;
    private final CharSequence mPassword;

    public ResourceOwnerPasswordGrant(OAuth2Client client, OAuth2Scope scope, CharSequence username, CharSequence password) {
        this.mClient = client;
        this.mScope = scope;
        this.mUsername = username;
        this.mPassword = password;
    }

    @Override
    public OAuth2AccessToken accessToken(HttpRequestExecutor executor) throws IOException, ProtocolError, ProtocolException {
        return this.mClient.accessToken(new ResourceOwnerPasswordTokenRequest(this.mScope, this.mUsername, this.mPassword), executor);
    }
}

