/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.state;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import net.iharder.Base64;
import org.dmfs.oauth2.client.OAuth2Client;
import org.dmfs.oauth2.client.OAuth2InteractiveGrant;
import org.json.JSONArray;
import org.json.JSONObject;

public final class InteractiveGrantFactory
implements org.dmfs.jems2.Function<String, OAuth2InteractiveGrant>,
Function<String, OAuth2InteractiveGrant> {
    private final OAuth2Client mOAuth2Client;

    public InteractiveGrantFactory(OAuth2Client oAuth2Client) {
        this.mOAuth2Client = oAuth2Client;
    }

    public OAuth2InteractiveGrant value(String state) {
        JSONObject object;
        try {
            object = new JSONObject(new String(Base64.decode((String)state), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to decode state", e);
        }
        JSONArray args = object.getJSONArray("args");
        String grantClass = object.getString("class");
        try {
            Constructor<?> constructor = Class.forName(grantClass).getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return ((OAuth2InteractiveGrant.OAuth2InteractiveGrantFactory)constructor.newInstance(new Object[0])).grant(this.mOAuth2Client, args);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalArgumentException("Can't Instantiate OAuth2InteractiveGrantFactory implementation " + grantClass, exception);
        }
    }

    @Override
    public OAuth2InteractiveGrant apply(String encodedState) {
        return this.value(encodedState);
    }
}

