/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.okhttp;

import java.net.URI;
import okhttp3.Response;
import org.dmfs.httpessentials.HttpStatus;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseEntity;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.okhttp.OkHttpResponseEntity;
import org.dmfs.httpessentials.okhttp.OkHttpResponseHeaders;
import org.dmfs.httpessentials.status.SimpleHttpStatus;

final class OkHttpResponse
implements HttpResponse {
    private final Response mResponse;
    private final URI mRequestUri;

    public OkHttpResponse(Response response, URI requestUri) {
        this.mResponse = response;
        this.mRequestUri = requestUri;
    }

    public HttpStatus status() {
        return new SimpleHttpStatus(this.mResponse.code(), this.mResponse.message());
    }

    public Headers headers() {
        return new OkHttpResponseHeaders(this.mResponse);
    }

    public HttpResponseEntity responseEntity() {
        return new OkHttpResponseEntity(this.mResponse.body());
    }

    public URI requestUri() {
        return this.mRequestUri;
    }

    public URI responseUri() {
        return this.mRequestUri;
    }
}

