/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.okhttp;

import java.io.InputStream;
import okhttp3.ResponseBody;
import org.dmfs.httpessentials.client.HttpResponseEntity;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.httpessentials.types.StringMediaType;
import org.dmfs.jems.optional.Optional;
import org.dmfs.jems.optional.adapters.Conditional;
import org.dmfs.jems.optional.decorators.Mapped;
import org.dmfs.jems.optional.elementary.NullSafe;

final class OkHttpResponseEntity
implements HttpResponseEntity {
    private final ResponseBody mResponseBody;

    public OkHttpResponseEntity(ResponseBody responseBody) {
        this.mResponseBody = responseBody;
    }

    public Optional<MediaType> contentType() {
        return new Mapped(mediaType -> new StringMediaType(mediaType.toString()), (Optional)new NullSafe((Object)this.mResponseBody.contentType()));
    }

    public Optional<Long> contentLength() {
        return new Conditional(length -> length >= 0L, (Object)this.mResponseBody.contentLength());
    }

    public InputStream contentStream() {
        return this.mResponseBody.byteStream();
    }
}

