/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.okhttp;

import java.io.IOException;
import java.net.URI;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.dmfs.httpessentials.HttpMethod;
import org.dmfs.httpessentials.client.HttpRequest;
import org.dmfs.httpessentials.client.HttpRequestExecutor;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.headers.Header;
import org.dmfs.httpessentials.okhttp.OkHttpRequestBody;
import org.dmfs.httpessentials.okhttp.OkHttpResponse;
import org.dmfs.jems.single.Single;

public final class PlainOkHttpExecutor
implements HttpRequestExecutor {
    private final Single<OkHttpClient> mOkHttpClient;

    public PlainOkHttpExecutor(Single<OkHttpClient> okHttpClient) {
        this.mOkHttpClient = okHttpClient;
    }

    public <T> T execute(URI uri, HttpRequest<T> request) throws IOException, ProtocolError, ProtocolException {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(uri.toURL());
        HttpMethod method = request.method();
        for (Header header : request.headers()) {
            requestBuilder.addHeader(header.type().name(), header.toString());
        }
        requestBuilder.method(method.verb(), (RequestBody)(method.supportsRequestPayload() ? new OkHttpRequestBody(request.requestEntity()) : null));
        OkHttpResponse httpResponse = new OkHttpResponse(((OkHttpClient)this.mOkHttpClient.value()).newCall(requestBuilder.build()).execute(), uri);
        return (T)request.responseHandler((HttpResponse)httpResponse).handleResponse((HttpResponse)httpResponse);
    }
}

