/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.optional.hamcrest;

import java.util.NoSuchElementException;
import org.dmfs.optional.Optional;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class AbsentMatcher<T>
extends TypeSafeDiagnosingMatcher<Optional<T>> {
    private static final AbsentMatcher<?> INSTANCE = new AbsentMatcher();
    private static final Object DUMMY_DEFAULT = new Object();

    public static <T> AbsentMatcher<T> isAbsent() {
        return INSTANCE;
    }

    protected boolean matchesSafely(Optional<T> item, Description mismatchDescription) {
        if (item.isPresent()) {
            mismatchDescription.appendText("present");
            return false;
        }
        try {
            item.value();
            mismatchDescription.appendText("value() did not throw NoSuchElementException");
            return false;
        }
        catch (NoSuchElementException noSuchElementException) {
            if (item.value(DUMMY_DEFAULT) != DUMMY_DEFAULT) {
                mismatchDescription.appendText("value(default) did not return the default value");
                return false;
            }
            return true;
        }
    }

    public void describeTo(Description description) {
        description.appendText("absent");
    }
}

