/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.optional.hamcrest;

import org.dmfs.optional.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.IsAnything;
import org.hamcrest.core.IsEqual;

public final class PresentMatcher<T>
extends TypeSafeDiagnosingMatcher<Optional<T>> {
    private final Matcher<T> mDelegate;

    public static <T> PresentMatcher<T> isPresent() {
        return new PresentMatcher<T>();
    }

    public static <T> PresentMatcher<T> isPresent(T expectedValue) {
        return new PresentMatcher<T>(expectedValue);
    }

    public static <T> PresentMatcher<T> isPresent(Matcher<T> delegate) {
        return new PresentMatcher<T>(delegate);
    }

    public PresentMatcher() {
        this((Matcher<T>)new IsAnything());
    }

    public PresentMatcher(T expected) {
        this((Matcher<T>)new IsEqual(expected));
    }

    public PresentMatcher(Matcher<T> delegate) {
        this.mDelegate = delegate;
    }

    protected boolean matchesSafely(Optional<T> item, Description mismatchDescription) {
        if (!item.isPresent()) {
            mismatchDescription.appendText("not present");
            return false;
        }
        if (!this.mDelegate.matches(item.value())) {
            mismatchDescription.appendText("present, but value ");
            this.mDelegate.describeMismatch(item.value(), mismatchDescription);
            return false;
        }
        if (!this.mDelegate.matches(item.value(null))) {
            mismatchDescription.appendText("present, but value(T) ");
            this.mDelegate.describeMismatch(item.value(), mismatchDescription);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("present with value ");
        this.mDelegate.describeTo(description);
    }
}

