/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.encoding;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.Normalized;

public final class Precoded
implements UriEncoded {
    private final CharSequence mEncoded;
    private final int mStart;
    private final int mEnd;
    private CharSequence mUtf8Plain;
    private UriEncoded mNormalized;

    public Precoded(CharSequence encoded) {
        this(encoded, 0, encoded.length());
    }

    private Precoded(CharSequence encoded, int start, int end) {
        this.mEncoded = encoded;
        this.mStart = start;
        this.mEnd = end;
    }

    @Override
    public UriEncoded normalized() {
        if (this.mNormalized == null) {
            this.mNormalized = new Normalized(this);
        }
        return this.mNormalized;
    }

    @Override
    public CharSequence decoded(String charset) throws UnsupportedEncodingException {
        if ("UTF-8".equalsIgnoreCase(charset)) {
            return this.decoded();
        }
        return this.decoded(this.mEncoded, this.mStart, this.mEnd, charset);
    }

    @Override
    public CharSequence decoded() {
        if (this.mUtf8Plain == null) {
            try {
                this.mUtf8Plain = this.decoded(this.mEncoded, this.mStart, this.mEnd, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Runtime doesn't support UTF-8");
            }
        }
        return this.mUtf8Plain;
    }

    @Override
    public int length() {
        return this.mEnd - this.mStart;
    }

    @Override
    public char charAt(int i) {
        if (i < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("Index %d is negative.", i));
        }
        if (this.mStart + i >= this.mEnd) {
            throw new ArrayIndexOutOfBoundsException(String.format("Index %d exceeds length %d", i, this.length()));
        }
        return this.mEncoded.charAt(i + this.mStart);
    }

    @Override
    public UriEncoded subSequence(int startIndex, int endIndex) {
        if (startIndex == 0 && endIndex == this.length()) {
            return this;
        }
        if (endIndex < startIndex) {
            throw new ArrayIndexOutOfBoundsException(String.format("Start index %d < end index %d.", startIndex, endIndex));
        }
        if (startIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("Start index %d is negative.", startIndex));
        }
        if (this.mStart + endIndex > this.mEnd) {
            throw new ArrayIndexOutOfBoundsException(String.format("End index %d exceeds length %d", endIndex, this.length()));
        }
        return new Precoded(this.mEncoded, startIndex + this.mStart, endIndex + this.mStart);
    }

    public int hashCode() {
        return this.normalized().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof UriEncoded && this.normalized().equals(obj);
    }

    @Override
    public String toString() {
        return this.mEncoded.subSequence(this.mStart, this.mEnd).toString();
    }

    private CharSequence decoded(CharSequence encoded, int start, int end, String charSet) throws UnsupportedEncodingException {
        if (start == end) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(encoded.length());
        int i = start;
        while (i < end) {
            char c = encoded.charAt(i);
            if (c == '%') {
                if (i + 2 >= end) {
                    throw new IllegalArgumentException("Illegal percent encoding.");
                }
                out.write((this.decodeDigit(encoded.charAt(i + 1)) << 4) + this.decodeDigit(encoded.charAt(i + 2)));
                i += 3;
                continue;
            }
            out.write(c);
            ++i;
        }
        return out.toString(charSet);
    }

    private int decodeDigit(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        int r = c - 65 & 0xFFFFFFDF;
        if (r < 0 || r > 5) {
            throw new IllegalArgumentException(String.format("%c is not a valid hex digit", new Object[0]));
        }
        return r + 10;
    }
}

