/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.parameters.adapters;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dmfs.iterators.AbstractConvertedIterator;
import org.dmfs.iterators.AbstractFilteredIterator;
import org.dmfs.iterators.ConvertedIterator;
import org.dmfs.iterators.FilteredIterator;
import org.dmfs.optional.Optional;
import org.dmfs.rfc3986.parameters.Parameter;
import org.dmfs.rfc3986.parameters.ParameterList;
import org.dmfs.rfc3986.parameters.ParameterType;

public final class OptionalParameter<V>
implements Optional<V> {
    private final Iterable<V> mDelegate;
    private V mValue;
    private Boolean mIsPresent;

    public OptionalParameter(final ParameterType<V> parameterType, final ParameterList delegate) {
        this.mDelegate = new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new ConvertedIterator((Iterator)new FilteredIterator(delegate.iterator(), (AbstractFilteredIterator.IteratorFilter)new AbstractFilteredIterator.IteratorFilter<Parameter>(){

                    public boolean iterate(Parameter element) {
                        return element.name().toString().equals(parameterType.name().toString());
                    }
                }), new AbstractConvertedIterator.Converter<V, Parameter>(){

                    public V convert(Parameter element) {
                        return parameterType.value(element);
                    }
                });
            }
        };
    }

    public boolean isPresent() {
        if (this.mIsPresent == null) {
            this.mIsPresent = this.mDelegate.iterator().hasNext();
        }
        return this.mIsPresent;
    }

    public V value(V defaultValue) {
        return this.isPresent() ? this.value() : defaultValue;
    }

    public V value() throws NoSuchElementException {
        if (this.mValue == null) {
            Iterator<V> iterator = this.mDelegate.iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException("No value present. Better call \"isPresent()\" beforehand.");
            }
            this.mValue = iterator.next();
        }
        return this.mValue;
    }
}

