/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.paths;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.dmfs.iterators.SerialIterator;
import org.dmfs.rfc3986.Path;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.IdempotentEncoded;

public final class Resolved
implements Path {
    private final Path mBase;
    private final Path mReference;

    public Resolved(Path base, Path reference) {
        this.mBase = base;
        this.mReference = reference;
    }

    @Override
    public boolean isEmpty() {
        return this.mBase.isEmpty() && this.mReference.isEmpty();
    }

    @Override
    public boolean isAbsolute() {
        return this.mBase.isAbsolute() || this.mReference.isAbsolute();
    }

    @Override
    public Iterator<UriEncoded> iterator() {
        UriEncoded last;
        if (this.mReference.isEmpty()) {
            return Collections.unmodifiableList(this.normalize(this.mBase.iterator())).iterator();
        }
        if (this.mReference.isAbsolute()) {
            return Collections.unmodifiableList(this.normalize(this.mReference.iterator())).iterator();
        }
        LinkedList<UriEncoded> segments = this.normalize(this.mBase.iterator());
        if (!(segments.isEmpty() || IdempotentEncoded.EMPTY.equals(last = segments.getLast()) || IdempotentEncoded.CURRENT.equals(last) || IdempotentEncoded.PARENT.equals(last))) {
            segments.removeLast();
        }
        return Collections.unmodifiableList(this.normalize((Iterator<UriEncoded>)new SerialIterator(new Iterator[]{segments.iterator(), this.mReference.iterator()}))).iterator();
    }

    private LinkedList<UriEncoded> normalize(Iterator<UriEncoded> segments) {
        LinkedList<UriEncoded> pathSegments = new LinkedList<UriEncoded>();
        int count = 0;
        int backSteps = 0;
        boolean isAbsolute = false;
        boolean endWithEmptySegment = false;
        boolean singleDot = false;
        while (segments.hasNext()) {
            UriEncoded segment = segments.next();
            if (IdempotentEncoded.EMPTY.equals(segment)) {
                if (count == 0) {
                    isAbsolute = true;
                } else {
                    endWithEmptySegment = true;
                }
            } else if (IdempotentEncoded.CURRENT.equals(segment)) {
                if (pathSegments.isEmpty() && !isAbsolute) {
                    singleDot = true;
                } else {
                    endWithEmptySegment = true;
                }
            } else if (IdempotentEncoded.PARENT.equals(segment)) {
                if (backSteps > 0) {
                    pathSegments.removeLast();
                    --backSteps;
                } else if (!isAbsolute) {
                    pathSegments.addLast(segment);
                }
                endWithEmptySegment = true;
                singleDot = pathSegments.isEmpty() && !isAbsolute;
            } else {
                pathSegments.addLast(segment);
                ++backSteps;
                endWithEmptySegment = false;
                singleDot = false;
            }
            ++count;
        }
        if (isAbsolute) {
            pathSegments.addFirst(IdempotentEncoded.EMPTY);
        }
        if (singleDot) {
            pathSegments.addLast(IdempotentEncoded.CURRENT);
            pathSegments.addLast(IdempotentEncoded.EMPTY);
        } else if (endWithEmptySegment && (pathSegments.size() <= 1 || !IdempotentEncoded.EMPTY.equals(pathSegments.getLast()))) {
            pathSegments.addLast(IdempotentEncoded.EMPTY);
        }
        return pathSegments;
    }
}

