/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.uris;

import org.dmfs.optional.Absent;
import org.dmfs.optional.Optional;
import org.dmfs.optional.Present;
import org.dmfs.rfc3986.Authority;
import org.dmfs.rfc3986.Fragment;
import org.dmfs.rfc3986.Path;
import org.dmfs.rfc3986.Query;
import org.dmfs.rfc3986.Scheme;
import org.dmfs.rfc3986.Uri;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.paths.EmptyPath;

public final class StructuredUri
implements Uri {
    private final Optional<Scheme> mScheme;
    private final Optional<Authority> mAuthority;
    private final Path mPath;
    private final Optional<Query> mQuery;
    private final Optional<Fragment> mFragment;

    public StructuredUri(Scheme scheme, Authority authority) {
        this((Optional<Scheme>)new Present((Object)scheme), (Optional<Authority>)new Present((Object)authority), (Path)EmptyPath.INSTANCE, (Optional<Query>)Absent.absent(), (Optional<Fragment>)Absent.absent());
    }

    public StructuredUri(Scheme scheme, Authority authority, Path path) {
        this((Optional<Scheme>)new Present((Object)scheme), (Optional<Authority>)new Present((Object)authority), path, (Optional<Query>)Absent.absent(), (Optional<Fragment>)Absent.absent());
    }

    public StructuredUri(Scheme scheme, Authority authority, Path path, Query query) {
        this((Optional<Scheme>)new Present((Object)scheme), (Optional<Authority>)new Present((Object)authority), path, (Optional<Query>)new Present((Object)query), (Optional<Fragment>)Absent.absent());
    }

    public StructuredUri(Scheme scheme, Authority authority, Path path, Query query, Fragment fragment) {
        this((Optional<Scheme>)new Present((Object)scheme), (Optional<Authority>)new Present((Object)authority), path, (Optional<Query>)new Present((Object)query), (Optional<Fragment>)new Present((Object)fragment));
    }

    private StructuredUri(Optional<Scheme> scheme, Optional<Authority> authority, Path path, Optional<Query> query, Optional<Fragment> fragment) {
        this.mScheme = scheme;
        this.mAuthority = authority;
        this.mPath = path;
        this.mQuery = query;
        this.mFragment = fragment;
        if (authority.isPresent() && !path.isAbsolute() && !path.isEmpty()) {
            throw new IllegalArgumentException("URIs with an authority must have an absolute or empty path.");
        }
        if (!(scheme.isPresent() || authority.isPresent() || this.mPath.isAbsolute() || path.isEmpty() || !((UriEncoded)path.iterator().next()).toString().contains(":"))) {
            throw new IllegalArgumentException("URIs without scheme and authority must have not have a \":\" in the first path segment unless the path is absolute.");
        }
    }

    @Override
    public Optional<? extends Scheme> scheme() {
        return this.mScheme;
    }

    @Override
    public Optional<? extends Authority> authority() {
        return this.mAuthority;
    }

    @Override
    public Path path() {
        return this.mPath;
    }

    @Override
    public Optional<? extends Query> query() {
        return this.mQuery;
    }

    @Override
    public Optional<? extends Fragment> fragment() {
        return this.mFragment;
    }

    @Override
    public boolean isHierarchical() {
        return !this.mScheme.isPresent() || this.mAuthority.isPresent() || this.mPath.isAbsolute();
    }

    @Override
    public boolean isAbsolute() {
        return this.mScheme.isPresent();
    }
}

