/*
 * Copyright 2017 dmfs GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.dmfs.rfc3986.schemes;

import org.dmfs.rfc3986.Scheme;
import org.dmfs.rfc3986.validation.CharSets;
import org.dmfs.rfc3986.validation.Validated;

import java.util.Locale;


/**
 * A {@link Scheme} derived from a String.
 *
 * @author Marten Gajda
 */
public final class StringScheme implements Scheme
{
    private final CharSequence mScheme;


    public StringScheme(String scheme)
    {
        mScheme = new Validated(scheme.toLowerCase(Locale.ENGLISH), CharSets.SCHEME_CHAR);
    }


    @Override
    public int length()
    {
        return mScheme.length();
    }


    @Override
    public char charAt(int i)
    {
        return mScheme.charAt(i);
    }


    @Override
    public CharSequence subSequence(int i, int i1)
    {
        return mScheme.subSequence(i, i1);
    }


    @Override
    public String toString()
    {
        return mScheme.toString();
    }
}
