/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.authorities;

import java.util.NoSuchElementException;
import org.dmfs.optional.Absent;
import org.dmfs.optional.Optional;
import org.dmfs.optional.Present;
import org.dmfs.rfc3986.Authority;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.authorities.EncodedAuthority;
import org.dmfs.rfc3986.utils.Parsed;

public final class OptionalLazyAuthority
implements Optional<Authority>,
Parsed {
    private final UriEncoded mUriEncoded;
    private Optional<Authority> mOptionalAuthority;

    public OptionalLazyAuthority(UriEncoded uriEncoded) {
        this.mUriEncoded = uriEncoded;
    }

    public boolean isPresent() {
        return this.authority().isPresent();
    }

    public Authority value(Authority defaultValue) {
        return (Authority)this.authority().value((Object)defaultValue);
    }

    public Authority value() throws NoSuchElementException {
        return (Authority)this.authority().value();
    }

    private Optional<Authority> authority() {
        if (this.mOptionalAuthority == null) {
            this.mOptionalAuthority = this.parsedAuthority();
        }
        return this.mOptionalAuthority;
    }

    private Optional<Authority> parsedAuthority() {
        if (this.mUriEncoded.length() < 2 || this.mUriEncoded.charAt(0) != '/' || this.mUriEncoded.charAt(1) != '/') {
            return Absent.absent();
        }
        return new Present((Object)new EncodedAuthority(this.mUriEncoded.subSequence(2, this.mUriEncoded.length())));
    }

    @Override
    public int parsedLength() {
        return this.authority().isPresent() ? ((EncodedAuthority)this.mOptionalAuthority.value()).parsedLength() + 2 : 0;
    }
}

