/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.parameters.parameters;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.FormPrecoded;
import org.dmfs.rfc3986.encoding.IdempotentEncoded;
import org.dmfs.rfc3986.parameters.Parameter;

public final class UrlEncodedParameter
implements Parameter {
    private final CharSequence mEncodedParameter;
    private final String mCharSet;
    private UriEncoded mName;
    private UriEncoded mValue;

    public UrlEncodedParameter(UriEncoded encodedPair) {
        this(encodedPair, "UTF-8");
    }

    public UrlEncodedParameter(UriEncoded encodedParameter, String charSet) throws UnsupportedCharsetException {
        this.mEncodedParameter = encodedParameter;
        this.mCharSet = charSet;
        Charset.forName(charSet);
    }

    @Override
    public CharSequence name() {
        this.parse();
        try {
            return this.mName.decoded(this.mCharSet);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(String.format("CharSet %s not supported by Runtime", this.mCharSet));
        }
    }

    @Override
    public CharSequence textValue() {
        this.parse();
        try {
            return this.mValue.decoded(this.mCharSet);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(String.format("CharSet %s not supported by Runtime", this.mCharSet));
        }
    }

    private void parse() {
        if (this.mName == null) {
            int equalsPos = this.equalsPos(this.mEncodedParameter);
            this.mName = new FormPrecoded(this.mEncodedParameter.subSequence(0, equalsPos));
            this.mValue = equalsPos < this.mEncodedParameter.length() ? new FormPrecoded(this.mEncodedParameter.subSequence(equalsPos + 1, this.mEncodedParameter.length())) : IdempotentEncoded.EMPTY;
        }
    }

    private int equalsPos(CharSequence charSequence) {
        int i;
        int len = charSequence.length();
        for (i = 0; i < len && charSequence.charAt(i) != '='; ++i) {
        }
        return i;
    }
}

